#ifndef DAILYMOTIONUSERGROUPLISTMODEL_H
#define DAILYMOTIONUSERGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class DailymotionUserGroupListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserGroupListModel(QObject *parent = 0);
    ~DailymotionUserGroupListModel() {}
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE GroupItem* getFromQML(int row) const;
#endif

private slots:
    void onGroupAdded(int row);
    void onGroupRemoved(int row);

signals:
    void countChanged(int count);

private:
    QHash<int, QByteArray> m_roleNames;
};

#endif // DAILYMOTIONUSERGROUPLISTMODEL_H
