#include "youtubesubscriptionlistmodel.h"
#include "youtube.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

YouTubeSubscriptionListModel::YouTubeSubscriptionListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[SubscriptionIdRole] = "subscriptionId";
    m_roleNames[UsernameRole] = "username";
    m_roleNames[ChannelNameRole] = "channelName";
#ifndef QML_USER_INTERFACE
    m_roleNames[AvatarRole] = "avatar";
#endif
    m_roleNames[AvatarUrlRole] = "avatarUrl";
    m_roleNames[VideoCountRole] = "videoCount";
    m_roleNames[DescriptionRole] = "description";
    m_roleNames[ViewCountRole] = "viewCount";
    m_roleNames[SubscriberCountRole] = "subscriberCount";
    m_roleNames[SubscriptionRole] = "subscription";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!YouTube::instance()->subscriptionsLoaded()) {
        YouTube::instance()->getSubscriptions();
    }

    this->connect(YouTube::instance(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    this->connect(YouTube::instance(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
}

YouTubeSubscriptionListModel::~YouTubeSubscriptionListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> YouTubeSubscriptionListModel::roleNames() const {
    return m_roleNames;
}
#endif

void YouTubeSubscriptionListModel::onSubscriptionAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void YouTubeSubscriptionListModel::onSubscriptionRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int YouTubeSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return YouTube::instance()->subscriptions()->size();
}

QVariant YouTubeSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->channelName();
#ifndef QML_USER_INTERFACE
    case AvatarRole:
        return m_cache->thumbnail(YouTube::instance()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
#endif
    case AvatarUrlRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->avatarUrl();
    case VideoCountRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

QVariant YouTubeSubscriptionListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<UserItem> YouTubeSubscriptionListModel::get(int row) const {
    return QSharedPointer<UserItem>(YouTube::instance()->subscriptions()->at(row));
}

#ifdef QML_USER_INTERFACE
UserItem* YouTubeSubscriptionListModel::getFromQML(int row) const {
    return YouTube::instance()->subscriptions()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void YouTubeSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
