#include "notifications.h"
#include "settings.h"
#ifndef QML_USER_INTERFACE
#include <QProgressDialog>
#ifdef Q_WS_MAEMO_5
#include "../maemo5_gui/windowstack.h"
#include <QMaemo5InformationBox>
#endif
#endif

Notifications* notificationsInstance = 0;

Notifications::Notifications(QObject *parent) :
    QObject(parent)
  #ifndef QML_USER_INTERFACE
    ,m_progressDialog(0)
  #endif
{
    if (!notificationsInstance) {
        notificationsInstance = this;
    }
}

Notifications* Notifications::instance() {
    return notificationsInstance;
}

#ifdef Q_WS_MAEMO_5
void Notifications::showAlert(const QString &message) {
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message);
}

void Notifications::showInfo(const QString &message) {
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message, QMaemo5InformationBox::NoTimeout);
}

void Notifications::showError(const QString &message) {
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message, QMaemo5InformationBox::NoTimeout);
}

void Notifications::toggleBusy(bool busy) {
    if (QWidget *window = WindowStack::instance()->currentWindow()) {
        window->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
    }
}
#endif

void Notifications::onAlert(const QString &message) {
#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message);
#else
    emit alert(message);
#endif
}

void Notifications::onInfo(const QString &message) {
#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message, QMaemo5InformationBox::NoTimeout);
#else
    emit info(message);
#endif
}

void Notifications::onError(const QString &message) {
#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message, QMaemo5InformationBox::NoTimeout);
#else
    emit error(message);
#endif
}

void Notifications::showProgressDialog(const QString &message, int numberOfOperations) {
    if (numberOfOperations == 0) {
        return;
    }
#ifndef QML_USER_INTERFACE
    if (!m_progressDialog) {
        m_progressDialog = new QProgressDialog(WindowStack::instance()->rootWindow());
        m_progressDialog->setWindowTitle(tr("Please wait"));
        m_progressDialog->setCancelButtonText(tr("Cancel"));
        m_progressDialog->setMinimumDuration(0);
        m_progressDialog->setMinimum(0);
    }
#ifdef Q_WS_MAEMO_5
    switch (Settings::instance()->screenOrientation()) {
    case ScreenOrientation::LockLandscape:
        m_progressDialog->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        break;
    case ScreenOrientation::LockPortrait:
        m_progressDialog->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        break;
    default:
        m_progressDialog->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    }
#endif
    m_progressDialog->setLabelText(message);
    m_progressDialog->setMaximum(numberOfOperations);
    m_progressDialog->setValue(0);
    m_progressDialog->show();

    if (this->sender()) {
        this->connect(m_progressDialog, SIGNAL(canceled()), this->sender(), SLOT(cancelCurrentOperation()));
    }
#else
    emit busy(message, numberOfOperations);
#endif
}

void Notifications::updateProgressDialog(int progress) {
#ifndef QML_USER_INTERFACE
    if ((m_progressDialog) && (!m_progressDialog->wasCanceled())) {
        m_progressDialog->setValue(progress);
    }
#else
    emit busyProgressChanged(progress);
#endif
}

#ifndef QML_USER_INTERFACE
void Notifications::cancelProgressDialog() {
    if (m_progressDialog) {
        m_progressDialog->reset();

        if (this->sender()) {
            this->disconnect(m_progressDialog, SIGNAL(canceled()), this->sender(), SLOT(cancelCurrentOperation()));
        }
    }
}
#endif
