#ifndef DAILYMOTION_H
#define DAILYMOTION_H

#include "../../cutetubeapp/src/base/enums.h"
#include <QObject>
#include <QUrl>
#include <QString>

class QNetworkAccessManager;
class QNetworkReply;

class Dailymotion : public QObject {
    Q_OBJECT

public:
    explicit Dailymotion(QObject *parent = 0);
    ~Dailymotion();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_user; }
    inline bool userSignedIn() const { return !this->accessToken().isEmpty(); }
    QNetworkReply* createReply(QString feed, int offset = 0);

public slots:
    void setAccount(const QString &user = QString(), const QString &token = QString(), const QString &refresh = QString());
    void refreshAccessToken();

private:
    inline void setUsername(const QString &user) { m_user = user; emit usernameChanged(user); }
    inline QString accessToken() const { return m_token; }
    inline void setAccessToken(const QString &token) { m_token = token; emit userSignedInChanged(); }
    inline QString refreshToken() const { return m_refreshToken; }
    inline void setRefreshToken(const QString &token) { m_refreshToken = token; }

private slots:
    void checkTokenRefresh();

signals:
    void usernameChanged(const QString &username);
    void userSignedInChanged();
    void newAccountSet();
    void accessTokenRefreshed(const QString &token, const QString &refresh);
    void refreshError();

private:
    QNetworkAccessManager *m_nam;
    QString m_clientId;
    QString m_clientSecret;
    QString m_user;
    QString m_token;
    QString m_refreshToken;
};

#endif // DAILYMOTION_H
