#include "vimeouserlisttab.h"
#include "vimeouserlistdelegate.h"
#include "vimeovideolistwindow.h"
#include "vimeochannelwindow.h"
#include "../base/vimeouserlistmodel.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include "listview.h"
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

VimeoUserListTab::VimeoUserListTab(const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_userId(userId),
    m_model(new VimeoUserListModel(this)),
    m_listView(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VimeoUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));

    this->onOrientationChanged();
}

void VimeoUserListTab::setFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void VimeoUserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoUserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoUserListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void VimeoUserListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void VimeoUserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void VimeoUserListTab::showUserChannel(const QString &userId) {
    VimeoChannelWindow *window = new VimeoChannelWindow(userId, WindowStack::instance()->currentWindow());
    window->show();
}
