#include "vimeouserlistdelegate.h"
#include "../base/abstractuserlistmodel.h"
#include <QApplication>
#include <QPainter>
#include <QMaemo5Style>

VimeoUserListDelegate::VimeoUserListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void VimeoUserListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 5));
    imageRect.setSize(QSize(60, 60));

    QImage image = index.data(AbstractUserListModel::AvatarRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }

    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawRect(imageRect);
    painter->setPen(Qt::white);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(imageRect.right() + 5, imageRect.top()));
    textRect.setRight(textRect.right() - 5);
    textRect.setHeight(60);

    painter->drawText(textRect, Qt::TextWordWrap | Qt::AlignVCenter, index.data(AbstractUserListModel::UsernameRole).toString());
    painter->restore();
}

QSize VimeoUserListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 70);
}
