#ifndef VIDEOCONTROLS_H
#define VIDEOCONTROLS_H

#include "../base/videoitem.h"
#include <QWidget>
#include <QMediaPlayer>
#include <QShowEvent>
#include <QHideEvent>
#include <QKeyEvent>

class VideoPlayerButton;
class PlaybackListModel;
class QSlider;
class QProgressBar;
class QLabel;
class QHBoxLayout;
class QTimer;
class QListView;
class QModelIndex;

class VideoControls : public QWidget
{
    Q_OBJECT

public:
    explicit VideoControls(QMediaPlayer *player, QList< QSharedPointer<VideoItem> > playlist, QWidget *parent = 0);
    void keyPressEvent(QKeyEvent *event);

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private slots:
    void onPositionChanged(qint64 position);
    void onDurationChanged(qint64 duration);
    void onStateChanged(QMediaPlayer::State state);
    void onBufferStatusChanged(int progress);
    void onMediaStatusChanged(QMediaPlayer::MediaStatus status);
    void onVideoLoading(const QString &message);
    void onUrlReady(const QUrl &url);
    void onItemClicked(const QModelIndex &index);
    void togglePlayPause();
    void previous();
    void next();
    void setPosition();
    void hideListView();
    void listViewUp();
    void listViewDown();
    void setPlaylistIndex();

signals:
    void back();
    
private:
    QMediaPlayer *m_player;
    PlaybackListModel *m_playlist;
    QListView *m_listView;
    VideoPlayerButton *m_previousButton;
    VideoPlayerButton *m_playButton;
    VideoPlayerButton *m_nextButton;
    VideoPlayerButton *m_backButton;
    QSlider *m_progressSlider;
    QProgressBar *m_bufferProgressBar;
    QLabel *m_positionLabel;
    QLabel *m_durationLabel;
    QHBoxLayout *m_hbox;
    QTimer *m_listTimer;
    int m_currentIndex;
};

#endif // VIDEOCONTROLS_H
