#include "ratingindicator.h"
#include <QImage>
#include <QPainter>
#include <QMaemo5Style>

RatingIndicator::RatingIndicator(int value, int count, QWidget *parent) :
    QWidget(parent),
    m_minimum(0),
    m_maximum(5),
    m_value(value),
    m_count(count)
{
    this->setFixedSize(180, 20);
}

void RatingIndicator::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QPainter painter(this);
    QRect ratingRect = this->rect();
    ratingRect.setWidth(ratingRect.height());

    for (int i = 1; i <= this->maximum(); i++) {
        if (i > value()) {
            painter.setOpacity(0.3);
        }
        else {
            painter.setOpacity(1);
        }

        painter.drawImage(ratingRect, QImage("/usr/share/icons/hicolor/48x48/hildon/imageviewer_favourite.png"));
        ratingRect.moveLeft(ratingRect.right());
    }

    ratingRect.setWidth(this->rect().width() - ratingRect.left());

    QFont font;
    font.setPixelSize(ratingRect.height());

    painter.setFont(font);
    painter.setOpacity(1);
    painter.setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter.drawText(ratingRect, Qt::AlignVCenter, QString(" (%1)").arg(this->count()));
}
