#ifndef ABSTRACTGROUPLISTMODEL_H
#define ABSTRACTGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class AbstractGroupListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
#endif
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit AbstractGroupListModel(QObject *parent = 0);
    ~AbstractGroupListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE GroupItem* getFromQML(int row) const;
#endif

public slots:
    void clear();
    void insertGroup(int row, QSharedPointer<GroupItem> group);
    void appendGroup(QSharedPointer<GroupItem> group);
    bool removeGroup(const QVariant &value, int role = IdRole);

protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

#ifndef QML_USER_INTERFACE
protected slots:
    void onThumbnailReady();
#endif

protected:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QList< QSharedPointer<GroupItem> > m_list;
};

#endif // ABSTRACTGROUPLISTMODEL_H
