#ifndef YOUTUBEPLAYLISTLISTTAB_H
#define YOUTUBEPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "listview.h"
#include "youtubeplaylistlistmodel.h"
#include <QLabel>
#include <QGridLayout>

class YouTubePlaylistListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubePlaylistListTab(Session *session, QWidget *parent = 0);
    void setPlaylistFeed(const QString &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    Session *m_session;
    ListView *m_listView;
    YouTubePlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPLAYLISTLISTTAB_H
