#ifndef TRANSFERLISTWINDOW_H
#define TRANSFERLISTWINDOW_H

#include "stackedwindow.h"
#include "listview.h"
#include <QLabel>
#include <QMenu>
#include <QAction>

class TransferListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit TransferListWindow(Session *session, QWidget *parent);
    ~TransferListWindow();

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showContextMenu(const QPoint &pos);
    void showPriorityDialog();
    void setTransferPriority(TransferItem::Priority priority);
    void pauseOrResumeTransfer();
    void cancelTransfer();
    void onCountChanged();
    
private:
    ListView *m_listView;
    QLabel *m_noResultsLabel;
    QMenu *m_contextMenu;
    QAction *m_priorityAction;
    QAction *m_pauseResumeAction;
    QAction *m_cancelAction;
};

#endif // TRANSFERLISTWINDOW_H
