#ifndef SHARETOFACEBOOKDIALOG_H
#define SHARETOFACEBOOKDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include <QLineEdit>
#include <QTextEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>

class ShareToFacebookDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit ShareToFacebookDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void shareVideo();
    
private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QTextEdit *m_messageEdit;
    QScrollArea *m_scrollArea;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QGridLayout *m_grid;
};

#endif // SHARETOFACEBOOKDIALOG_H
