#ifndef DAILYMOTIONPROFILETAB_H
#define DAILYMOTIONPROFILETAB_H

#include "abstracttab.h"
#include "session.h"
#include "useritem.h"
#include "separatorlabel.h"
#include "avatarlabel.h"
#include <QLabel>
#include <QPushButton>
#include <QScrollArea>
#include <QGridLayout>

class DailymotionProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionProfileTab(Session *session, const QString &userId, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleSubscription();
    void onSubscribedChanged();

private:
    Session *m_session;
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_viewsLabel;
    QLabel *m_ageLabel;
    QLabel *m_genderLabel;
    QLabel *m_locationLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_subscriptionButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPROFILETAB_H
