#ifndef ABSTRACTCOMMENTLISTMODEL_H
#define ABSTRACTCOMMENTLISTMODEL_H

#include "thumbnailcache.h"
#include "commentitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class AbstractCommentListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        BodyRole,
        ArtistRole,
        ArtistIdRole,
        ArtistAvatarRole,
        DateRole,
        VideoIdRole,
        ReplyIdRole,
        IndentRole,
        LoadingRole
    };

public:
    explicit AbstractCommentListModel(ThumbnailCache *cache, QObject *parent = 0);
    ~AbstractCommentListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<CommentItem> get(int row) const;
    void insertComment(int row, QSharedPointer<CommentItem> comment);
    void appendComment(QSharedPointer<CommentItem> comment);
    bool removeComment(const QString &id);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<CommentItem> > m_list;
};

#endif // ABSTRACTCOMMENTLISTMODEL_H
