#ifndef YOUTUBESUBSCRIPTIONLISTMODEL_H
#define YOUTUBESUBSCRIPTIONLISTMODEL_H

#include "session.h"
#include <QAbstractListModel>

class YouTubeSubscriptionListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
        AvatarRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit YouTubeSubscriptionListModel(Session *session, QObject *parent = 0);
    ~YouTubeSubscriptionListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<UserItem> get(int row) const { return m_session->youtube()->subscriptions()->at(row); }

private slots:
    void onSubscriptionAdded(int row);
    void onSubscriptionRemoved(int row);
    void onThumbnailReady();

private:
    Session *m_session;
    ThumbnailCache *m_cache;
};

#endif // YOUTUBESUBSCRIPTIONLISTMODEL_H
