#include "youtubeplaylistdelegate.h"
#include "abstractplaylistlistmodel.h"
#include <QApplication>
#include <QStaticText>

YouTubePlaylistDelegate::YouTubePlaylistDelegate(QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent)
{
}

void YouTubePlaylistDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 130);
    titleRect.setRight(titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(60);

    painter->drawText(titleRect, Qt::TextWordWrap, index.data(AbstractPlaylistListModel::TitleRole).toString());

    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);

    titleRect.moveTop(titleRect.bottom());

    painter->drawText(titleRect, QString("%1 videos").arg(index.data(AbstractPlaylistListModel::VideoCountRole).toInt()));

    QRect infoRect = option.rect;
    infoRect.setLeft(titleRect.left());
    infoRect.setRight(titleRect.right());
    infoRect.setTop(infoRect.bottom() - 75);
    infoRect.setBottom(infoRect.bottom() - 5);

    QPen oldPen = painter->pen();
    QPen newPen(QColor("#4d4d4d"));
    painter->setPen(newPen);

    QString description = index.data(AbstractPlaylistListModel::DescriptionRole).toString();

    QStaticText descriptionText(description.isEmpty() ? tr("No description") : description);
    descriptionText.setTextWidth(infoRect.width());

    int descriptionHeight = descriptionText.size().height();

    if (descriptionHeight <= infoRect.height()) {
        descriptionText.setTextOption(QTextOption(Qt::AlignBottom));
        infoRect.setTop(infoRect.bottom() - descriptionHeight);
    }

    painter->setClipRect(infoRect);
    painter->drawStaticText(infoRect.topLeft(), descriptionText);

    QRect imageRect = option.rect;
    imageRect.setLeft(imageRect.left() + 5);
    imageRect.setTop(imageRect.top() + 5);
    imageRect.setWidth(120);
    imageRect.setHeight(90);

    painter->setClipping(false);

    QImage image = index.data(AbstractPlaylistListModel::ThumbnailRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }
    else {
        painter->drawImage(imageRect.left() + 36, imageRect.top() + 26, QImage("/usr/share/icons/hicolor/48x48/hildon/general_video_file.png"));
    }

    newPen.setWidth(0);
    painter->drawRect(imageRect);

    painter->setFont(oldFont);
    painter->setPen(oldPen);
}

QSize YouTubePlaylistDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 180);
}
