#ifndef XTUBE_H
#define XTUBE_H

#include "videoitem.h"
#include "enums.h"
#include <QObject>
#include <QNetworkAccessManager>

class XTube : public QObject
{
    Q_OBJECT

public:
    explicit XTube(QObject *parent = 0);
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    void search(
            Services::VideoService service,
            QString query,
            int offset = 1,
            Queries::QueryOrder order = Queries::Relevance,
            Queries::TimeFilter time = Queries::AllTime,
            Queries::DurationFilter duration = Queries::Any
            );

private slots:
    void parseXVideosPage();
    void parseXHamsterPage();
    void parseJoggsPage();
    void parseYouJizzPage();
    void parseRampantTVPage();

private:
    void searchXHamster(QString query, int offset, Queries::QueryOrder order, Queries::TimeFilter time, Queries::DurationFilter duration);
    void searchXVideos(QString query, int offset, Queries::QueryOrder order, Queries::TimeFilter time, Queries::DurationFilter duration);
    void searchJoggs(QString query, int offset);
    void searchYouJizz(QString query, int offset);
    void searchRampantTV(QString query, int offset);

signals:
    void gotVideos(QList< QSharedPointer<VideoItem> > videos);
    void error(const QString &errorString);

private:
    QNetworkAccessManager *m_nam;
    QHash<int, QString> m_xhamsterOrders;
    QHash<int, QString> m_xhamsterTimeFilters;
    QHash<int, QString> m_xhamsterDurationFilters;
    QHash<int, QString> m_xvideosOrders;
    QHash<int, QString> m_xvideosTimeFilters;
    QHash<int, QString> m_xvideosDurationFilters;
};

#endif // XTUBE_H
