#include "settings.h"
#include <QDir>

Settings::Settings(QObject *parent) :
    QSettings(QString("Marxian"), QString("cuteTube"), parent) {
}

Settings::~Settings() {
    saveSettings();
}

void Settings::restoreSettings() {
    beginGroup("Media");
    setYouTubePlaybackQualitySet(value("youtubePlaybackQuality", QVariantList()).toList());
    setYouTubeDownloadQualitySet(value("youtubeDownloadQuality", QVariantList()).toList());
    setDailymotionPlaybackQualitySet(value("dailymotionPlaybackQuality", QVariantList()).toList());
    setDailymotionDownloadQualitySet(value("dailymotionDownloadQuality", QVariantList()).toList());
    setVimeoPlaybackQualitySet(value("vimeoPlaybackQuality", QVariantList()).toList());
    setVimeoDownloadQualitySet(value("vimeoDownloadQuality", QVariantList()).toList());
    setUploadAttribute(value("uploadAttribute", tr("Uploaded via cuteTube")).toString());
    setMediaPlayer(value("mediaPlayer", QString("mediaplayer")).toString());
    setMediaPlayerCommand(value("mediaPlayerCommand", QString()).toString());
    setXtubeEnabled(value("xtubeEnabled", false).toBool());
    setLanguageFilter(value("languageFilter", QString()).toString());
    endGroup();

    beginGroup("Transfers");
    setDefaultTransferStatus(static_cast<TransferItem::Status>(value("defaultTransferStatus", 0).toInt()));
    setDownloadPath(value("downloadPath", QString("/home/user/MyDocs/cuteTube/")).toString());
    endGroup();

    beginGroup("Search");
    setSafeSearch(value("safeSearch", false).toBool());
    setSearchSite(static_cast<Services::VideoService>(value("searchSite", 0).toInt()));
    setShowSearchSite(value("showSearchSite", true).toBool());
    setSearchOrder(static_cast<Queries::QueryOrder>(value("searchOrder", 0).toInt()));
    setShowSearchOrder(value("showSearchOrder", true).toBool());
    setSearchTime(static_cast<Queries::TimeFilter>(value("searchTime", 0).toInt()));
    setShowSearchTime(value("showSearchTime", false).toBool());
    setSearchDuration(static_cast<Queries::DurationFilter>(value("searchDuration", 0).toInt()));
    setShowSearchDuration(value("showSearchDuration", false).toBool());
    setSearchType(static_cast<Queries::QueryType>(value("searchType", 0).toInt()));
    setShowSearchType(value("showSearchType", true).toBool());
    setShowSearchLanguage(value("showSearchLanguage", true).toBool());
    endGroup();

    beginGroup("System");
    setLanguage(value("language", QString("en")).toString());
    setScreenOrientation(static_cast<ScreenOrientation::Orientation>(value("screenOrientation", 0).toInt()));
    endGroup();
}

void Settings::saveSettings() {
    beginGroup("Media");
    setValue("youtubePlaybackQuality", toVariantList(m_youtubePlaybackSet));
    setValue("youtubeDownloadQuality", toVariantList(m_youtubeDownloadSet));
    setValue("dailymotionPlaybackQuality", toVariantList(m_dailymotionPlaybackSet));
    setValue("dailymotionDownloadQuality", toVariantList(m_dailymotionDownloadSet));
    setValue("vimeoPlaybackQuality", toVariantList(m_vimeoPlaybackSet));
    setValue("vimeoDownloadQuality", toVariantList(m_vimeoDownloadSet));
    setValue("uploadAttribute", uploadAttribute());
    setValue("mediaPlayer", mediaPlayer());
    setValue("mediaPlayerCommand", mediaPlayerCommand());
    setValue("languageFilter", languageFilter());
    endGroup();

    beginGroup("Transfers");
    setValue("defaultTransferStatus", defaultTransferStatus());
    setValue("downloadPath", downloadPath());
    endGroup();

    beginGroup("Search");
    setValue("safeSearch", safeSearch());
    setValue("searchSite", Services::VideoService(searchSite()));
    setValue("showSearchSite", showSearchSite());
    setValue("searchOrder", Queries::QueryOrder(searchOrder()));
    setValue("showSearchOrder", showSearchOrder());
    setValue("searchTime", Queries::TimeFilter(searchTime()));
    setValue("showSearchTime", showSearchTime());
    setValue("searchDuration", Queries::DurationFilter(searchDuration()));
    setValue("showSearchDuration", showSearchDuration());
    setValue("searchType", Queries::QueryType(searchType()));
    setValue("showSearchType", showSearchType());
    setValue("showSearchLanguage", showSearchLanguage());
    endGroup();

    beginGroup("System");
    setValue("language", language());
    setValue("screenOrientation", ScreenOrientation::Orientation(screenOrientation()));
    endGroup();
}

QVariantList Settings::toVariantList(const QSet<int> &set) {
    QVariantList varList;
    QList<int> list = set.toList();

    while (!list.isEmpty()) {
        varList.append(list.takeFirst());
    }

    return varList;
}

QVariantList Settings::toVariantList(const QSet<QByteArray> &set) {
    QVariantList varList;
    QList<QByteArray> list = set.toList();

    while (!list.isEmpty()) {
        varList.append(list.takeFirst());
    }

    return varList;
}

void Settings::setYouTubePlaybackQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_youtubePlaybackSet.insert(qualityList.at(i).toInt());
    }

    m_youtubePlaybackSet.insert(18);
    emit youtubePlaybackQualityChanged(m_youtubePlaybackSet);
}

void Settings::setYouTubeDownloadQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_youtubeDownloadSet.insert(qualityList.at(i).toInt());
    }

    m_youtubeDownloadSet.insert(18);
    emit youtubeDownloadQualityChanged(m_youtubeDownloadSet);
}

void Settings::setDailymotionPlaybackQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_dailymotionPlaybackSet.insert(qualityList.at(i).toByteArray());
    }

    m_dailymotionPlaybackSet.insert("sdURL");
    emit dailymotionPlaybackQualityChanged(m_dailymotionPlaybackSet);
}

void Settings::setDailymotionDownloadQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_dailymotionDownloadSet.insert(qualityList.at(i).toByteArray());
    }

    m_dailymotionDownloadSet.insert("sdURL");
    emit dailymotionDownloadQualityChanged(m_dailymotionDownloadSet);
}

void Settings::setVimeoPlaybackQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_vimeoPlaybackSet.insert(qualityList.at(i).toByteArray());
    }

    m_vimeoPlaybackSet.insert("mobile");
    emit vimeoPlaybackQualityChanged(m_vimeoPlaybackSet);
}

void Settings::setVimeoDownloadQualitySet(const QVariantList &qualityList) {
    for (int i = 0; i < qualityList.size(); i++) {
        m_vimeoDownloadSet.insert(qualityList.at(i).toByteArray());
    }

    m_vimeoDownloadSet.insert("mobile");
    emit vimeoDownloadQualityChanged(m_vimeoDownloadSet);
}

void Settings::setEnableYouTube1080Playback(bool enable) {
    if (enable) {
        m_youtubePlaybackSet.insert(37);
    }
    else {
        m_youtubePlaybackSet.remove(37);
    }

    emit youtubePlaybackQualityChanged(m_youtubePlaybackSet);
}

void Settings::setEnableYouTube720Playback(bool enable) {
    if (enable) {
        m_youtubePlaybackSet.insert(22);
    }
    else {
        m_youtubePlaybackSet.remove(22);
    }

    emit youtubePlaybackQualityChanged(m_youtubePlaybackSet);
}

void Settings::setEnableYouTube480Playback(bool enable) {
    if (enable) {
        m_youtubePlaybackSet.insert(35);
    }
    else {
        m_youtubePlaybackSet.remove(35);
    }

    emit youtubePlaybackQualityChanged(m_youtubePlaybackSet);
}

void Settings::setEnableYouTube360Playback(bool enable) {
    if (enable) {
        m_youtubePlaybackSet.insert(34);
    }
    else {
        m_youtubePlaybackSet.remove(34);
    }

    emit youtubePlaybackQualityChanged(m_youtubePlaybackSet);
}

void Settings::setEnableYouTube1080Download(bool enable) {
    if (enable) {
        m_youtubeDownloadSet.insert(37);
    }
    else {
        m_youtubeDownloadSet.remove(37);
    }

    emit youtubeDownloadQualityChanged(m_youtubeDownloadSet);
}

void Settings::setEnableYouTube720Download(bool enable) {
    if (enable) {
        m_youtubeDownloadSet.insert(22);
    }
    else {
        m_youtubeDownloadSet.remove(22);
    }

    emit youtubeDownloadQualityChanged(m_youtubeDownloadSet);
}

void Settings::setEnableYouTube480Download(bool enable) {
    if (enable) {
        m_youtubeDownloadSet.insert(35);
    }
    else {
        m_youtubeDownloadSet.remove(35);
    }

    emit youtubeDownloadQualityChanged(m_youtubeDownloadSet);
}

void Settings::setEnableYouTube360Download(bool enable) {
    if (enable) {
        m_youtubeDownloadSet.insert(34);
    }
    else {
        m_youtubeDownloadSet.remove(34);
    }

    emit youtubeDownloadQualityChanged(m_youtubeDownloadSet);
}

void Settings::setEnableDailymotion720Playback(bool enable) {
    if (enable) {
        m_dailymotionPlaybackSet.insert("hd720URL");
    }
    else {
        m_dailymotionPlaybackSet.remove("hd720URL");
    }

    emit dailymotionPlaybackQualityChanged(m_dailymotionPlaybackSet);
}

void Settings::setEnableDailymotion480Playback(bool enable) {
    if (enable) {
        m_dailymotionPlaybackSet.insert("hqURL");
    }
    else {
        m_dailymotionPlaybackSet.remove("hqURL");
    }

    emit dailymotionPlaybackQualityChanged(m_dailymotionPlaybackSet);
}

void Settings::setEnableDailymotion720Download(bool enable) {
    if (enable) {
        m_dailymotionDownloadSet.insert("hd720URL");
    }
    else {
        m_dailymotionDownloadSet.remove("hd720URL");
    }

    emit dailymotionDownloadQualityChanged(m_dailymotionDownloadSet);
}

void Settings::setEnableDailymotion480Download(bool enable) {
    if (enable) {
        m_dailymotionDownloadSet.insert("hqURL");
    }
    else {
        m_dailymotionDownloadSet.remove("hqURL");
    }

    emit dailymotionDownloadQualityChanged(m_dailymotionDownloadSet);
}

void Settings::setEnableVimeo720Playback(bool enable) {
    if (enable) {
        m_vimeoPlaybackSet.insert("hd");
    }
    else {
        m_vimeoPlaybackSet.remove("hd");
    }

    emit vimeoPlaybackQualityChanged(m_vimeoPlaybackSet);
}

void Settings::setEnableVimeo360Playback(bool enable) {
    if (enable) {
        m_vimeoPlaybackSet.insert("sd");
    }
    else {
        m_vimeoPlaybackSet.remove("sd");
    }

    emit vimeoPlaybackQualityChanged(m_vimeoPlaybackSet);
}

void Settings::setEnableVimeo720Download(bool enable) {
    if (enable) {
        m_vimeoDownloadSet.insert("hd");
    }
    else {
        m_vimeoDownloadSet.remove("hd");
    }

    emit dailymotionDownloadQualityChanged(m_vimeoDownloadSet);
}

void Settings::setEnableVimeo360Download(bool enable) {
    if (enable) {
        m_vimeoDownloadSet.insert("sd");
    }
    else {
        m_vimeoDownloadSet.remove("sd");
    }

    emit dailymotionDownloadQualityChanged(m_vimeoDownloadSet);
}

void Settings::setDefaultTransferStatus(TransferItem::Status status) {
    m_transferStatus = status;
    emit defaultTransferStatusChanged(status);
}

void Settings::setDownloadPath(const QString &path) {
    m_path = path;

    if (!m_path.endsWith("/")) {
        m_path.append("/");
    }

    QDir pathCheck(m_path + ".thumbnails/");

    if (pathCheck.exists(m_path + "thumbnails/")) {
        pathCheck.rename(m_path + "thumbnails/", pathCheck.path());
    }

    pathCheck.mkpath(pathCheck.path());

    emit downloadPathChanged(m_path);
}

void Settings::setSafeSearch(bool safe) {
    m_safeSearch = safe;
    emit safeSearchChanged(safe);
}

void Settings::setSearchSite(Services::VideoService site) {
    m_searchSite = site;
    emit searchSiteChanged(site);
}

void Settings::setShowSearchSite(bool show) {
    m_showSearchSite = show;
}

void Settings::setSearchOrder(Queries::QueryOrder order) {
    m_searchOrder = order;
    emit searchOrderChanged(order);
}

void Settings::setShowSearchOrder(bool show) {
    m_showSearchOrder = show;
}

void Settings::setSearchTime(Queries::TimeFilter time) {
    m_searchTime = time;
    emit searchTimeChanged(time);
}

void Settings::setShowSearchTime(bool show) {
    m_showSearchTime = show;
}

void Settings::setSearchDuration(Queries::DurationFilter duration) {
    m_searchDuration = duration;
    emit searchDurationChanged(duration);
}

void Settings::setShowSearchDuration(bool show) {
    m_showSearchDuration = show;
}

void Settings::setSearchType(Queries::QueryType type) {
    m_searchType = type;
    emit searchTypeChanged(type);
}

void Settings::setShowSearchType(bool show) {
    m_showSearchType = show;
}

void Settings::setLanguageFilter(const QString &language) {
    m_languageFilter = language;
    emit languageFilterChanged(language);
}

void Settings::setShowSearchLanguage(bool show) {
    m_showSearchLanguage = show;
}

void Settings::setLanguage(const QString &lang) {
    m_language = lang;
}

void Settings::setUploadAttribute(const QString &attribute) {
    m_attribute = attribute;
}

void Settings::setMediaPlayer(const QString &player) {
    m_mediaplayer = player;
    emit mediaPlayerChanged(player);
}

void Settings::setMediaPlayerCommand(const QString &command) {
    m_command = command;
    emit mediaPlayerCommandChanged(command);
}

void Settings::setXtubeEnabled(bool enabled) {
    m_xtubeEnabled = enabled;
}

void Settings::setScreenOrientation(ScreenOrientation::Orientation orientation) {
    m_orientation = orientation;
    emit screenOrientationChanged(orientation);
}
