#include "querydialog.h"

QueryDialog::QueryDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_message(new QLabel(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Yes | QDialogButtonBox::No, Qt::Vertical, this)),
    m_grid(new QGridLayout(this))
{
    m_message->setWordWrap(true);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    onOrientationChanged();
}

QueryDialog::QueryDialog(const QString &message, QWidget *parent) :
    AbstractDialog(parent),
    m_message(new QLabel(message, this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Yes | QDialogButtonBox::No, Qt::Vertical, this)),
    m_grid(new QGridLayout(this))
{
    m_message->setWordWrap(true);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    onOrientationChanged();
}

void QueryDialog::setMessage(const QString &message) {
    m_message->setText(message);
    onOrientationChanged();
}

void QueryDialog::setLandscapeLayout() {
    setFixedHeight(m_message->height() + 150);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_message, 0, 0, Qt::AlignTop);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void QueryDialog::setPortraitLayout() {
    setFixedHeight(m_message->height() + 250);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_message, 0, 0, Qt::AlignTop);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}
