#include "homewindow.h"
#include "aboutdialog.h"
#include "settingsdialog.h"
#include "accountsdialog.h"
#include "searchdialog.h"
#include "categoriesdialog.h"
#include "querydialog.h"
#include "videoservicedialog.h"
#include "linkgoogleaccountdialog.h"
#include "facebookauthdialog.h"
#include "twitterauthdialog.h"
#include "feedurls.h"
#include "youtubemychannelwindow.h"
#include "dailymotionmychannelwindow.h"
#include "youtubevideolistwindow.h"
#include "dailymotionvideolistwindow.h"
#include "youtubeplaylistlistwindow.h"
#include "dailymotionplaylistlistwindow.h"
#include "youtubevideoinfowindow.h"
#include "dailymotionvideoinfowindow.h"
#include "vimeovideoinfowindow.h"
#include "youtubeuserlistwindow.h"
#include "dailymotionuserlistwindow.h"
#include "dailymotiongrouplistwindow.h"
#include "playbackqueuewindow.h"
#include "transferlistwindow.h"
#include "vimeovideolistwindow.h"
#include "xtubevideolistwindow.h"
#include "socialvideolistwindow.h"
#include "archivewindow.h"
#include <QMenuBar>

HomeWindow::HomeWindow(QWidget *parent) :
    StackedWindow(parent),
    m_myChannelButton(new NavButton(tr("My Channel"), ":/images/mychannel.png", this)),
    m_latestButton(new NavButton(tr("Latest Videos"), ":/images/latest.png", this)),
    m_categoriesButton(new NavButton(tr("Categories"), ":/images/categories.png", this)),
    m_socialButton(new NavButton(tr("Social"), ":/images/social.png", this)),
    m_searchButton(new NavButton(tr("Search"), ":/images/search.png", this)),
    m_queueButton(new NavButton(tr("Queue"), ":/images/queue.png", this)),
    m_transfersButton(new NavButton(tr("Transfers"), ":/images/transfers.png", this)),
    m_archiveButton(new NavButton(tr("Archive"), ":/images/archive.png", this)),
    m_accountsButton(new NavButton(tr("Accounts"), ":/images/accounts.png", this)),
    m_accountsAction(menuBar()->addAction(tr("Accounts"), this, SLOT(showAccounts()))),
    m_settingsAction(menuBar()->addAction(tr("Settings"), this, SLOT(showSettingsDialog()))),
    m_aboutAction(menuBar()->addAction(tr("About"), this, SLOT(showAboutDialog()))),
    m_grid(0)
{    
    setWindowTitle("cuteTube");
    setAttribute(Qt::WA_DeleteOnClose, false);
    setCentralWidget(new QWidget(this));
    m_grid = new QGridLayout(centralWidget());
    m_grid->setContentsMargins(0, 0, 0, 0);

    connect(m_myChannelButton, SIGNAL(clicked()), this, SLOT(showMyChannel()));
    connect(m_latestButton, SIGNAL(clicked()), this, SLOT(showLatestVideos()));
    connect(m_categoriesButton, SIGNAL(clicked()), this, SLOT(showCategoriesDialog()));
    connect(m_socialButton, SIGNAL(clicked()), this, SLOT(showSocialVideos()));
    connect(m_searchButton, SIGNAL(clicked()), this, SLOT(showSearchDialog()));
    connect(m_queueButton, SIGNAL(clicked()), this, SLOT(showPlaybackQueue()));
    connect(m_transfersButton, SIGNAL(clicked()), this, SLOT(showTransfers()));
    connect(m_archiveButton, SIGNAL(clicked()), this, SLOT(showArchive()));
    connect(m_accountsButton, SIGNAL(clicked()), this, SLOT(showAccounts()));
    connect(m_session->youtube(), SIGNAL(requestToLinkGoogleAccount()), this, SLOT(showLinkGoogleAccountDialog()));
    connect(m_session->sharing(), SIGNAL(reauthenticateForFacebook()), this, SLOT(showFacebookAuthDialog()));
    connect(m_session->sharing(), SIGNAL(reauthenticateForTwitter()), this, SLOT(showTwitterAuthDialog()));

    onOrientationChanged();
}

void HomeWindow::setLandscapeLayout() {
    m_accountsButton->hide();
    m_accountsAction->setEnabled(true);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
}

void HomeWindow::setPortraitLayout() {
    m_accountsButton->show();
    m_accountsAction->setEnabled(false);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->removeWidget(m_accountsButton);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
}

void HomeWindow::showSettingsDialog() {
    SettingsDialog *dialog = new SettingsDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showAboutDialog() {
    AboutDialog *dialog = new AboutDialog(this);
    dialog->open();
}

void HomeWindow::showMyChannel(Services::VideoService service) {
    bool signedInToYouTube = m_session->youtube()->userSignedIn();
    bool signedInToDailymotion = m_session->dailymotion()->userSignedIn();

    if (service == Services::NoService) {
        if ((signedInToYouTube) && (signedInToDailymotion)) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showMyChannel(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            showYouTubeChannel();
        }
        else if (signedInToDailymotion) {
            showDailymotionChannel();
        }
    }
    else if (service == Services::YouTube) {
        showYouTubeChannel();
    }
    else if (service == Services::Dailymotion) {
        showDailymotionChannel();
    }
    else {
        showSignInDialog();
    }
}

void HomeWindow::showYouTubeChannel() {
    YouTubeMyChannelWindow *window = new YouTubeMyChannelWindow(m_session, this);
    window->show();
}

void HomeWindow::showDailymotionChannel() {
    DailymotionMyChannelWindow *window = new DailymotionMyChannelWindow(m_session, this);
    window->show();
}

void HomeWindow::showLatestVideos(Services::VideoService service) {
    bool signedInToYouTube = m_session->youtube()->userSignedIn();
    bool signedInToDailymotion = m_session->dailymotion()->userSignedIn();

    if (service == Services::NoService) {
        if ((signedInToYouTube) && (signedInToDailymotion)) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showLatestVideos(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            showLatestYouTubeVideos();
        }
        else if (signedInToDailymotion) {
            showLatestDailymotionVideos();
        }
    }
    else if (service == Services::YouTube) {
        showLatestYouTubeVideos();
    }
    else if (service == Services::Dailymotion) {
        showLatestDailymotionVideos();
    }
    else {
        showSignInDialog();
    }
}

void HomeWindow::showLatestYouTubeVideos() {
    YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
    window->setVideoFeed(YOUTUBE_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->setWindowTitle(tr("Latest subscription videos"));
    window->show();
}

void HomeWindow::showLatestDailymotionVideos() {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
    window->setVideoFeed(DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->setWindowTitle(tr("Latest subscription videos"));
    window->show();
}

void HomeWindow::showCategoriesDialog() {
    CategoriesDialog *dialog = new CategoriesDialog(this);
    dialog->open();

    connect(dialog, SIGNAL(categoryChosen(Services::VideoService,QString,QString)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QString)));
}

void HomeWindow::showCategoryVideos(Services::VideoService service, const QString &title, const QString &feed) {
    if (service == Services::YouTube) {
        YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
        window->setVideoFeed(feed);
        window->setWindowTitle(title);
        window->show();
    }
    else if (service == Services::Dailymotion) {
        DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
        window->setVideoFeed(feed);
        window->setWindowTitle(title);
        window->show();
    }
}

void HomeWindow::showSocialVideos() {
    if ((m_session->sharing()->userSignedInToFacebook()) || (m_session->sharing()->userSignedInToTwitter())) {
        SocialVideoListWindow *window = new SocialVideoListWindow(m_session, this);
        window->show();
    }
    else {
        showSocialSignInDialog();
    }
}

void HomeWindow::showSearchDialog() {
    SearchDialog *dialog = new SearchDialog(m_session->settings(), this);
    dialog->open();

    connect(dialog, SIGNAL(search(QString)), this, SLOT(search(QString)));
    connect(dialog, SIGNAL(goToVideo(QString)), this, SLOT(getVideoFromUrl(QString)));
}

void HomeWindow::search(const QString &query) {
    if (m_session->settings()->searchSite() == Services::YouTube) {
        if (m_session->settings()->searchType() == Queries::Videos) {
            YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder(), m_session->settings()->searchTime(), m_session->settings()->searchDuration(), m_session->settings()->languageFilter());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Playlists) {
            YouTubePlaylistListWindow *window = new YouTubePlaylistListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Users) {
            YouTubeUserListWindow *window = new YouTubeUserListWindow(m_session, this);
            window->search(query);
            window->show();
        }
    }
    else if (m_session->settings()->searchSite() == Services::Dailymotion) {
        if (m_session->settings()->searchType() == Queries::Videos) {
            DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder(), m_session->settings()->languageFilter());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Playlists) {
            DailymotionPlaylistListWindow *window = new DailymotionPlaylistListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Users) {
            DailymotionUserListWindow *window = new DailymotionUserListWindow(m_session, this);
            window->search(query);
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Groups) {
            DailymotionGroupListWindow *window = new DailymotionGroupListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
    }
    else if (m_session->settings()->searchSite() == Services::Vimeo) {
        VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, this);
        window->search(query, m_session->settings()->searchOrder());
        window->show();
    }
    else {
        XTubeVideoListWindow *window = new XTubeVideoListWindow(m_session, this);
        window->search(query, m_session->settings()->searchSite(), m_session->settings()->searchOrder(), m_session->settings()->searchTime(), m_session->settings()->searchDuration());
        window->show();
    }
}

void HomeWindow::getVideoFromUrl(const QString &url) {
    if (url.contains(QRegExp("youtube|youtu.be"))) {
        m_session->youtube()->getFullVideo(url);
        connect(m_session->youtube(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showYouTubeVideo(QSharedPointer<VideoItem>)));
    }
    else if (url.contains(QRegExp("dailymotion|dai.ly"))) {
        m_session->dailymotion()->getFullVideo(url);
        connect(m_session->dailymotion(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showDailymotionVideo(QSharedPointer<VideoItem>)));
    }
    else if (url.contains("vimeo")) {
        m_session->vimeo()->getFullVideo(url);
        connect(m_session->vimeo(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showVimeoVideo(QSharedPointer<VideoItem>)));
    }
}

void HomeWindow::showYouTubeVideo(QSharedPointer<VideoItem> video) {
    disconnect(m_session->youtube(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showYouTubeVideo(QSharedPointer<VideoItem>)));
    YouTubeVideoInfoWindow *window = new YouTubeVideoInfoWindow(m_session, video, this);
    window->show();
}

void HomeWindow::showDailymotionVideo(QSharedPointer<VideoItem> video) {
    disconnect(m_session->dailymotion(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showDailymotionVideo(VideoItem*)));
    DailymotionVideoInfoWindow *window = new DailymotionVideoInfoWindow(m_session, video, this);
    window->show();
}

void HomeWindow::showVimeoVideo(QSharedPointer<VideoItem> video) {
    disconnect(m_session->vimeo(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showVimeoVideo(QSharedPointer<VideoItem>)));
    VimeoVideoInfoWindow *window = new VimeoVideoInfoWindow(m_session, video, this);
    window->show();
}

void HomeWindow::showPlaybackQueue() {
    PlaybackQueueWindow *window = new PlaybackQueueWindow(m_session, this);
    window->show();
}

void HomeWindow::showTransfers() {
    TransferListWindow *window = new TransferListWindow(m_session, this);
    window->show();
}

void HomeWindow::showArchive() {
    ArchiveWindow *window = new ArchiveWindow(m_session, this);
    window->show();
}

void HomeWindow::showAccounts() {
    AccountsDialog *dialog = new AccountsDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("You are not signed in to an account. Would you like to sign in now?"));
    dialog->open();

    connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showSocialSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("This feature requires you to be signed in to a facebook or twitter account. Would you like to sign in now?"));
    dialog->open();

    connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showLinkGoogleAccountDialog() {
    LinkGoogleAccountDialog *dialog = new LinkGoogleAccountDialog(m_session, this);
    dialog->show();
}

void HomeWindow::showFacebookAuthDialog() {
    FacebookAuthDialog *dialog = new FacebookAuthDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showTwitterAuthDialog() {
    TwitterAuthDialog *dialog = new TwitterAuthDialog(m_session, this);
    dialog->open();
}
