#include "filterbox.h"

FilterBox::FilterBox(QWidget *parent) :
    QToolBar(parent),
    m_filterEdit(new QLineEdit(this)),
    m_cancelAction(addAction(QIcon::fromTheme("general_close"), QString(), this, SLOT(clear())))
{
    insertWidget(m_cancelAction, m_filterEdit);
    setFocusProxy(m_filterEdit);
    setAllowedAreas(Qt::BottomToolBarArea);

    connect(m_filterEdit, SIGNAL(textChanged(QString)), this, SIGNAL(filterTextChanged(QString)));
}

void FilterBox::clear() {
    m_filterEdit->clear();
    emit cleared();
}
