#ifndef DAILYMOTIONACCOUNTSLISTMODEL_H
#define DAILYMOTIONACCOUNTSLISTMODEL_H

#include "dailymotion.h"
#include "cookiejar.h"
#include <QSqlTableModel>

class DailymotionAccountsListModel : public QSqlTableModel
{
    Q_OBJECT

public:
    enum Roles {
        DisplayNameRole = Qt::DisplayRole,
        UsernameRole,
        AccessTokenRole,
        RefreshTokenRole,
        CookiesRole,
        ActiveRole
    };

public:
    explicit DailymotionAccountsListModel(Dailymotion *dailymotion, CookieJar *cookieJar, QObject *parent = 0);
    ~DailymotionAccountsListModel();
    QVariant data(const QModelIndex &idx, int role) const;

public slots:
    void switchAccount(int row);
    void addAccount(const QString &displayName, const QString &token, const QString &refresh);
    void deleteAccount(int row);

private:
    void setActiveAccount(int row);

signals:
    void accountSelected(const QString &user, const QString &token, const QString &refresh);
    void accountAdded(const QString &user, const QString &token, const QString &refresh);
    void accountDeleted();
    void gotCookies(const QByteArray &cookieString);
    void alert(const QString &message);
    void info(const QString &message);
    void warning(const QString &message);

private:
    Dailymotion *m_dailymotion;
    CookieJar *m_jar;
};

#endif // DAILYMOTIONACCOUNTSLISTMODEL_H
