#include "abstractplaylistlistmodel.h"

AbstractPlaylistListModel::AbstractPlaylistListModel(ThumbnailCache *cache, QObject *parent) :
    QAbstractListModel(parent),
    m_cache(cache)
{
    connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
}

AbstractPlaylistListModel::~AbstractPlaylistListModel() {
    m_list.clear();
    delete m_cache;
}

int AbstractPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_list.size();
}

QVariant AbstractPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case PlaylistIdRole:
        return m_list.at(index.row()).data()->playlistId();
    case TitleRole:
        return m_list.at(index.row()).data()->title();
    case ArtistRole:
        return m_list.at(index.row()).data()->artist();
    case DateRole:
        return m_list.at(index.row()).data()->date();
    case VideoCountRole:
        return m_list.at(index.row()).data()->videoCount();
    case ThumbnailRole:
        return m_cache->thumbnail(m_list.at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
    case DescriptionRole:
        return m_list.at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QSharedPointer<PlaylistItem> AbstractPlaylistListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<PlaylistItem>(m_list.at(row));
    }

    return QSharedPointer<PlaylistItem>();
}

void AbstractPlaylistListModel::insertPlaylist(int row, QSharedPointer<PlaylistItem> playlist) {
    beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, playlist);
    endInsertRows();
}

void AbstractPlaylistListModel::appendPlaylist(QSharedPointer<PlaylistItem> playlist) {
    beginInsertRows(QModelIndex(), rowCount(), rowCount());
    m_list.append(playlist);
    endInsertRows();
}

bool AbstractPlaylistListModel::removePlaylist(const QString &id) {
    bool removed = false;
    int i = 0;

    while ((!removed) && (i < m_list.size())) {
        removed = (get(i).data()->id() == id);

        if (removed) {
            removeRow(i);
        }

        i++;
    }

    return removed;
}

bool AbstractPlaylistListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent);

    if ((row >= 0) && (row < m_list.size())) {
        beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        endRemoveRows();

        return true;
    }

    return false;
}

void AbstractPlaylistListModel::onThumbnailReady() {
    emit dataChanged(index(0), index(rowCount() - 1));
}
