#ifndef SEARCHHISTORYDIALOG_H
#define SEARCHHISTORYDIALOG_H

#include "abstractdialog.h"
#include <QKeyEvent>

class SearchListModel;
class FilterBox;
class ListView;
class QModelIndex;
class QPushButton;
class QDialogButtonBox;
class QGridLayout;
class QMenu;

class SearchHistoryDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SearchHistoryDialog(SearchListModel *model, QWidget *parent = 0);
    void keyPressEvent(QKeyEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);
    void showFilterBox();
    void hideFilterBox();
    void showContextMenu(const QPoint &pos);
    void removeSearchTerm();

signals:
    void queryChosen(const QString &query);
    
private:
    SearchListModel *m_model;
    ListView *m_listView;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_clearButton;
    FilterBox *m_filterBox;
    QMenu *m_contextMenu;
    QAction *m_removeAction;
    QGridLayout *m_grid;
};

#endif // SEARCHHISTORYDIALOG_H
