#ifndef DAILYMOTIONMYCHANNELWINDOW_H
#define DAILYMOTIONMYCHANNELWINDOW_H

#include "stackedwindow.h"

class DailymotionProfileTab;
class DailymotionVideoListTab;
class DailymotionUserPlaylistListTab;
class DailymotionUserGroupListTab;
class DailymotionSubscriptionsTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class DailymotionMyChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit DailymotionMyChannelWindow(QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showSubscriptions();

private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_playlistsAction;
    QAction *m_groupsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    DailymotionProfileTab *m_profileTab;
    DailymotionVideoListTab *m_uploadsTab;
    DailymotionVideoListTab *m_favouritesTab;
    DailymotionUserPlaylistListTab *m_playlistsTab;
    DailymotionUserGroupListTab *m_groupsTab;
    DailymotionSubscriptionsTab *m_subscriptionsTab;
};

#endif // DAILYMOTIONMYCHANNELWINDOW_H
