#include "youtubeuserplaylistlistmodel.h"
#include "youtube.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

YouTubeUserPlaylistListModel::YouTubeUserPlaylistListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[PlaylistIdRole] = "playlistId";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[ArtistAvatarUrlRole] = "artistAvatarUrl";
    m_roleNames[DateRole] = "date";
    m_roleNames[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    m_roleNames[ThumbnailRole] = "thumbnail";
#endif
    m_roleNames[ThumbnailUrlRole] = "thumbnailUrl";
    m_roleNames[LargeThumbnailUrlRole] = "largeThumbnailUrl";
    m_roleNames[DescriptionRole] = "description";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!YouTube::instance()->playlistsLoaded()) {
        YouTube::instance()->getPlaylists();
    }

    this->connect(YouTube::instance(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
    this->connect(YouTube::instance(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
    this->connect(YouTube::instance(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
}

YouTubeUserPlaylistListModel::~YouTubeUserPlaylistListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> YouTubeUserPlaylistListModel::roleNames() const {
    return m_roleNames;
}
#endif

void YouTubeUserPlaylistListModel::onPlaylistAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void YouTubeUserPlaylistListModel::onPlaylistRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

void YouTubeUserPlaylistListModel::onPlaylistUpdated(int row) {
    emit dataChanged(this->index(row), this->index(row));
}

int YouTubeUserPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return YouTube::instance()->playlists()->size();
}

QVariant YouTubeUserPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->id();
    case PlaylistIdRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->playlistId();
    case TitleRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->title();
    case ArtistRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->artist();
    case ArtistAvatarUrlRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->artistAvatarUrl();
    case DateRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->date();
    case VideoCountRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(YouTube::instance()->playlists()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->thumbnailUrl();
    case LargeThumbnailUrlRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->largeThumbnailUrl();
    case DescriptionRole:
        return YouTube::instance()->playlists()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant YouTubeUserPlaylistListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> YouTubeUserPlaylistListModel::get(int row) const {
    return QSharedPointer<PlaylistItem>(YouTube::instance()->playlists()->at(row));
}

#ifdef QML_USER_INTERFACE
PlaylistItem* YouTubeUserPlaylistListModel::getFromQML(int row) const {
    return YouTube::instance()->playlists()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void YouTubeUserPlaylistListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
