#ifndef VIMEOMYCHANNELWINDOW_H
#define VIMEOMYCHANNELWINDOW_H

#include "stackedwindow.h"

class VimeoProfileTab;
class VimeoVideoListTab;
class VimeoUserAlbumListTab;
class VimeoUserGroupListTab;
class VimeoSubscriptionsTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class VimeoMyChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VimeoMyChannelWindow(QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showLikes();
    void showAlbums();
    void showGroups();
    void showSubscriptions();

private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_likesAction;
    QAction *m_albumsAction;
    QAction *m_groupsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    VimeoProfileTab *m_profileTab;
    VimeoVideoListTab *m_uploadsTab;
    VimeoVideoListTab *m_likesTab;
    VimeoUserAlbumListTab *m_albumsTab;
    VimeoUserGroupListTab *m_groupsTab;
    VimeoSubscriptionsTab *m_subscriptionsTab;
};

#endif // VIMEOMYCHANNELWINDOW_H
