#ifndef SEARCHORDERSELECTOR_H
#define SEARCHORDERSELECTOR_H

#include "../base/enums.h"
#include <QMaemo5ValueButton>

class SearchOrderModel;
class QMaemo5ListPickSelector;

class SearchOrderSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit SearchOrderSelector(const QString &text, QWidget *parent = 0);
    void setValue(Queries::QueryOrder value);
    Queries::QueryOrder currentValue();

private slots:
    void onSelected();

signals:
    void valueChanged(Queries::QueryOrder value);

private:
    SearchOrderModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // SEARCHORDERSELECTOR_H
