#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QNetworkProxy>

class Services : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoService)
    Q_ENUMS(SharingService)

public:
    enum VideoService {
        YouTube = 0,
        Dailymotion,
        Vimeo,
        NoService
    };

    enum SharingService {
        Facebook = 0,
        Twitter,
        Email,
        Clipboard
    };

    inline static QString serviceString(Services::VideoService service) {
        switch (service) {
        case Services::YouTube:
            return QString("YouTube");
        case Services::Dailymotion:
            return QString("Dailymotion");
        case Services::Vimeo:
            return QString("Vimeo");
        default:
            return tr("Unknown");
        }
    }

    inline static QString serviceString(Services::SharingService service) {
        switch (service) {
        case Services::Facebook:
            return QString("Facebook");
        case Services::Twitter:
            return QString("Twitter");
        case Services::Email:
            return tr("Email");
        case Services::Clipboard:
            return tr("Clipboard");
        default:
            return tr("Unknown");
        }
    }
};

class Videos : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoFormat)

public:
    enum VideoFormat {
        MobileLQ = 0,
        MobileNormal,
        LQ,
        Normal,
        HQ,
        HD,
        SuperHD,
        Unknown
    };
};

class Queries : public QObject
{
    Q_OBJECT

    Q_ENUMS(QueryType)
    Q_ENUMS(QueryOrder)
    Q_ENUMS(TimeFilter)
    Q_ENUMS(DurationFilter)

public:
    enum QueryType {
        Videos = 0,
        Playlists,
        Users,
        Groups
    };

    enum QueryOrder {
        Date = 0,
        Relevance,
        Views,
        Rating
    };

    enum TimeFilter {
        None = 0,
        AllTime,
        Today,
        ThisWeek,
        ThisMonth
    };

    enum DurationFilter {
        Any = 0,
        Short,
        Medium,
        Long
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
#ifdef SAILFISH_OS
        LockPortrait = 1,
        LockLandscape = 2,
        LockPortraitInverted = 4,
        LockLandcapeInverted = 8,
        Automatic = 15
#else
        Automatic = 0,
        LockPortrait,
        LockLandscape
#endif
    };

    inline static QString orientationString(Orientation orientation) {
        switch (orientation) {
        case Automatic:
            return tr("Automatic");
        case LockPortrait:
            return tr("Portrait");
        case LockLandscape:
            return tr("Landscape");
#ifdef SAILFISH_OS
        case LockPortraitInverted:
            return tr("Portrait (inverted)");
        case LockLandscapeInverted:
            return tr("Landscape (inverted)");
        default:
            return tr("Unknown");
#endif
        }
    }
};

class Transfers : public QObject
{
    Q_OBJECT

    Q_ENUMS(Status)
    Q_ENUMS(Priority)
    Q_ENUMS(TransferType)

public:
    enum Status {
        Paused = 0,
        Cancelled,
        Failed,
        Completed,
        Queued,
        Connecting,
        Downloading,
        Uploading,
        Converting,
        Unknown
    };

    enum Priority {
        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

    enum TransferType {
        Download = 0,
        Upload
    };

    inline static QString statusString(Status status) {
        switch (status) {
        case Queued:
            return tr("Queued");
        case Paused:
            return tr("Paused");
        case Connecting:
            return tr("Connecting");
        case Downloading:
            return tr("Downloading");
        case Uploading:
            return tr("Uploading");
        case Cancelled:
            return tr("Cancelled");
        case Failed:
            return tr("Failed");
        case Completed:
            return tr("Completed");
        case Converting:
            return tr("Converting");
        default:
            return tr("Unknown");
        }
    }

    inline static QString priorityString(Priority priority) {
        switch (priority) {
        case HighPriority:
            return tr("High");
        case NormalPriority:
            return tr("Normal");
        case LowPriority:
            return tr("Low");
        default:
            return tr("Unknown");
        }
    }

    inline static QString transferTypeString(TransferType type) {
        switch (type) {
        case Download:
            return tr("Download");
        case Upload:
            return tr("Upload");
        default:
            return tr("Unknown");
        }
    }
};

class NetworkProxyType : public QObject
{
    Q_OBJECT

    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };

    inline static QString networkProxyTypeString(ProxyType type) {
        switch (type) {
        case Socks5Proxy:
            return QString("SOCKS5");
        case HttpProxy:
            return QString("HTTP");
        case HttpCachingProxy:
            return QString("HTTP %1").arg(tr("caching"));
        default:
            return tr("Unknown");
        }
    }
};

#endif // ENUMS_H
