#ifndef AUDIOCONVERTER_H
#define AUDIOCONVERTER_H

#include <QObject>
#include <QProcess>

class AudioConverter : public QObject
{
    Q_OBJECT

public:
    explicit AudioConverter(QObject *parent = 0);
    ~AudioConverter();

    QString fileName() const;
    void setFileName(const QString &fileName);

    QString outputDirectory() const;
    void setOutputDirectory(const QString &directory);

    QString errorString() const;
    
public slots:
    void start();
    void start(const QString &fileName, const QString &outputDirectory);

private:
    void setErrorString(const QString &errorString);

private slots:
    void onProcessFinished(int exitCode, QProcess::ExitStatus status);

signals:
    void finished();
    void error();

private:
    QProcess *m_process;
    QString m_fileName;
    QString m_outputDirectory;
    QString m_errorString;
};

#endif // AUDIOCONVERTER_H
