#include "youtubeuserplaylistlisttab.h"
#include "youtubeplaylistdelegate.h"
#include "youtubenewplaylistdialog.h"
#include "youtubeplaylistvideoswindow.h"
#include "listview.h"
#include "../base/youtubeuserplaylistlistmodel.h"
#include "../base/youtube.h"
#include "../base/notifications.h"
#include "windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>
#include <QMaemo5Style>

YouTubeUserPlaylistListTab::YouTubeUserPlaylistListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new YouTubeUserPlaylistListModel(this)),
    m_contextMenu(new QMenu(this)),
    m_deleteAction(m_contextMenu->addAction(tr("Delete"), this, SLOT(deletePlaylist()))),
    m_newPlaylistAction(new QAction(tr("New playlist"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_newPlaylistAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();   

    if (YouTube::instance()->playlistsLoaded()) {
        this->onPlaylistsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(YouTube::instance(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_newPlaylistAction, SIGNAL(triggered()), this, SLOT(showNewPlaylistDialog()));

    this->onOrientationChanged();
}

void YouTubeUserPlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeUserPlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeUserPlaylistListTab::onPlaylistsLoaded() {
    Notifications::toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void YouTubeUserPlaylistListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void YouTubeUserPlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void YouTubeUserPlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(playlist, WindowStack::instance()->currentWindow());
    window->show();
}

void YouTubeUserPlaylistListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_deleteAction);
}

void YouTubeUserPlaylistListTab::deletePlaylist() {
    YouTube::instance()->deletePlaylist(m_listView->currentIndex().data(YouTubeUserPlaylistListModel::PlaylistIdRole).toString());
}

void YouTubeUserPlaylistListTab::showNewPlaylistDialog() {
    YouTubeNewPlaylistDialog *dialog = new YouTubeNewPlaylistDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(playlistCreated(QVariantMap)), YouTube::instance(), SLOT(createPlaylist(QVariantMap)));
}
