#include "transferprioritydialog.h"
#include "textlistdelegate.h"
#include "../base/selectionmodels.h"
#include <QListView>
#include <QVBoxLayout>

TransferPriorityDialog::TransferPriorityDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new TransferPriorityModel(this)),
    m_listView(new QListView(this))
{
    this->setWindowTitle(tr("Priority"));
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignCenter, m_listView));
    m_listView->setMinimumHeight(m_listView->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

void TransferPriorityDialog::setValue(Transfers::Priority priority) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Transfers::Priority>(m_model->value(i).toInt()) == priority;

        if (found) {
            m_listView->setCurrentIndex(m_model->index(i, 0));
        }

        i++;
    }

    if (!found) {
        m_listView->setCurrentIndex(m_model->index(0, 0));
    }
}

Transfers::Priority TransferPriorityDialog::currentValue() const {
    return static_cast<Transfers::Priority>(m_model->value(m_listView->currentIndex().row()).toInt());
}

void TransferPriorityDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Transfers::Priority>(m_model->value(index.row()).toInt()));
    this->accept();
}
