#include "playbackqueuewindow.h"
#include "videolistdelegate.h"
#include "youtubevideoinfowindow.h"
#include "dailymotionvideoinfowindow.h"
#include "vimeovideoinfowindow.h"
#include "playbackvideoselectionwindow.h"
#include "videoplaybackwindow.h"
#include "listview.h"
#include "../base/playbacklistmodel.h"
#include "../base/settings.h"
#include "../base/urlgrabber.h"
#include "../base/transfermanager.h"
#include <QAction>
#include <QLabel>
#include <QMenuBar>
#include <QMaemo5Style>

PlaybackQueueWindow::PlaybackQueueWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_playAction(this->menuBar()->addAction(tr("Play all"), this, SLOT(playAllVideos()))),
    m_removeAction(this->menuBar()->addAction(tr("Remove"), this, SLOT(removeVideos()))),
    m_videoDownloadAction(this->menuBar()->addAction(tr("Download"), this, SLOT(addVideoDownloads()))),
    m_audioDownloadAction(this->menuBar()->addAction(tr("Download (audio)"), this, SLOT(addAudioDownloads()))),
    m_contextMenu(new QMenu(this)),
    m_removeContextAction(m_contextMenu->addAction(tr("Remove"), this, SLOT(removeVideo()))),
    m_videoDownloadContextAction(m_contextMenu->addAction(tr("Download"), this, SLOT(addVideoDownload()))),
    m_audioDownloadContextAction(m_contextMenu->addAction(tr("Download (audio)"), this, SLOT(addAudioDownload()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No videos queued")), this))
{
    this->setWindowTitle(tr("Playback queue"));
    this->setCentralWidget(m_listView);

    VideoListDelegate *delegate = new VideoListDelegate(m_listView);

    m_listView->setModel(PlaybackListModel::playbackQueue());
    m_listView->setItemDelegate(delegate);
    m_noResultsLabel->setVisible(PlaybackListModel::playbackQueue()->rowCount() == 0);
    m_playAction->setEnabled((PlaybackListModel::playbackQueue()->rowCount() > 0) && (Settings::instance()->mediaPlayer() == "cutetube"));

    this->connect(PlaybackListModel::playbackQueue(), SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(delegate, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(delegate, SIGNAL(play(QModelIndex)), this, SLOT(playVideo(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));

    this->onOrientationChanged();
}

void PlaybackQueueWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void PlaybackQueueWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void PlaybackQueueWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
    m_playAction->setEnabled(count > 0);
}

void PlaybackQueueWindow::removeVideos() {
    PlaybackVideoSelectionWindow *window = new PlaybackVideoSelectionWindow(tr("Remove"), SLOT(removeVideos()), this);
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void PlaybackQueueWindow::addVideoDownloads() {
    PlaybackVideoSelectionWindow *window = new PlaybackVideoSelectionWindow(tr("Download"), SLOT(addVideoDownloads()), this);
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void PlaybackQueueWindow::addAudioDownloads() {
    PlaybackVideoSelectionWindow *window = new PlaybackVideoSelectionWindow(tr("Download"), SLOT(addAudioDownloads()), this);
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void PlaybackQueueWindow::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_removeContextAction);
}

void PlaybackQueueWindow::removeVideo() {
    PlaybackListModel::playbackQueue()->removeVideo(m_listView->currentIndex().row());
}

void PlaybackQueueWindow::addVideoDownload() {
    TransferManager::instance()->addDownloadTransfer(PlaybackListModel::playbackQueue()->get(m_listView->currentIndex().row()));
}

void PlaybackQueueWindow::addAudioDownload() {
    TransferManager::instance()->addDownloadTransfer(PlaybackListModel::playbackQueue()->get(m_listView->currentIndex().row()), true);
}

void PlaybackQueueWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        Services::VideoService service = static_cast<Services::VideoService>(index.data(AbstractVideoListModel::ServiceRole).toInt());

        switch (service) {
        case Services::YouTube:
            this->showYouTubeVideoInfo(PlaybackListModel::playbackQueue()->get(index.row()));
            break;
        case Services::Dailymotion:
            this->showDailymotionVideoInfo(PlaybackListModel::playbackQueue()->get(index.row()));
            break;
        case Services::Vimeo:
            this->showVimeoVideoInfo(PlaybackListModel::playbackQueue()->get(index.row()));
            break;
        default:
            return;
        }
    }
}

void PlaybackQueueWindow::showYouTubeVideoInfo(QSharedPointer<VideoItem> video) {
    YouTubeVideoInfoWindow *infoWindow = new YouTubeVideoInfoWindow(video, this);
    infoWindow->show();
}

void PlaybackQueueWindow::showDailymotionVideoInfo(QSharedPointer<VideoItem> video) {
    DailymotionVideoInfoWindow *infoWindow = new DailymotionVideoInfoWindow(video, this);
    infoWindow->show();
}

void PlaybackQueueWindow::showVimeoVideoInfo(QSharedPointer<VideoItem> video) {
    VimeoVideoInfoWindow *infoWindow = new VimeoVideoInfoWindow(video, this);
    infoWindow->show();
}

void PlaybackQueueWindow::playVideo(const QModelIndex &index) {
    if (Settings::instance()->mediaPlayer() == "cutetube") {
        VideoPlaybackWindow *window = new VideoPlaybackWindow(QList< QSharedPointer<VideoItem> >() << PlaybackListModel::playbackQueue()->get(index.row()), this);
        window->show();
    }
    else {
        UrlGrabber::instance()->getVideoUrl(static_cast<Services::VideoService>(index.data(AbstractVideoListModel::ServiceRole).toInt()), index.data(AbstractVideoListModel::VideoIdRole).toString());
    }
}

void PlaybackQueueWindow::playAllVideos() {
    QList< QSharedPointer<VideoItem> > videos;

    for (int i = 0; i < PlaybackListModel::playbackQueue()->rowCount(); i++) {
        videos.append(PlaybackListModel::playbackQueue()->get(i));
    }

    VideoPlaybackWindow *window = new VideoPlaybackWindow(videos, this);
    window->show();
}
