#ifndef TRANSFERPRIORITYDIALOG_H
#define TRANSFERPRIORITYDIALOG_H

#include "../base/enums.h"
#include "abstractdialog.h"

class TransferPriorityModel;
class QListView;
class QModelIndex;

class TransferPriorityDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TransferPriorityDialog(QWidget *parent = 0);
    Transfers::Priority currentValue() const;
    void setValue(Transfers::Priority priority);

private slots:
    void onItemClicked(const QModelIndex &index);
    
signals:
    void valueChanged(Transfers::Priority priority);

private:
    TransferPriorityModel *m_model;
    QListView *m_listView;
};

#endif // TRANSFERPRIORITYDIALOG_H
