#ifndef SHARINGDIALOG_H
#define SHARINGDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class SharingModel;
class QListView;
class QModelIndex;

class SharingDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SharingDialog(QWidget *parent = 0);
    Services::SharingService currentValue() const;

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(Services::SharingService service);

private:
    SharingModel *m_model;
    QListView *m_listView;
};

#endif // SHARINGDIALOG_H
