#ifndef RESOURCELOADER_H
#define RESOURCELOADER_H

#include "../base/useritem.h"
#include "../base/videoitem.h"
#include <QObject>
#include <QSharedPointer>
#include <QStringList>

class ResourceLoader : public QObject
{
    Q_OBJECT

public:
    explicit ResourceLoader(QObject *parent = 0);
    ~ResourceLoader();

    static ResourceLoader* instance();
    
public slots:
    bool display(const QString &url, bool unwindStack = true);
    bool display(const QStringList &url, bool unwindStack = true);

    bool play(const QString &url, bool unwindStack = true);
    bool play(const QStringList &url, bool unwindStack = true);

    void displayUser(Services::VideoService service, const QString &id);
    void displayVideo(Services::VideoService service, const QString &id);
    void playVideo(Services::VideoService service, const QString &id);

private slots:
    void displayYouTubeUser(const QString &id);
    void displayDailymotionUser(const QString &id);
    void displayVimeoUser(const QString &id);

    void displayYouTubeVideo(QSharedPointer<VideoItem> video);
    void displayDailymotionVideo(QSharedPointer<VideoItem> video);
    void displayVimeoVideo(QSharedPointer<VideoItem> video);

    void playVideo(QSharedPointer<VideoItem> video);

private:
    static ResourceLoader *self;
};

#endif // RESOURCELOADER_H
