#ifndef DAILYMOTIONUSERLISTTAB_H
#define DAILYMOTIONUSERLISTTAB_H

#include "abstracttab.h"

class DailymotionUserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QAction;
class QModelIndex;
class QUrl;

class DailymotionUserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionUserListTab(const QString &userId, QWidget *parent = 0);
    void setFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    QString m_userId;
    DailymotionUserListModel *m_model;
    ListView *m_listView;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONUSERLISTTAB_H
