#include "vimeousergrouplistmodel.h"
#include "vimeo.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

VimeoUserGroupListModel::VimeoUserGroupListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[DateRole] = "date";
    m_roleNames[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    m_roleNames[ThumbnailRole] = "thumbnail";
#endif
    m_roleNames[ThumbnailUrlRole] = "thumbnailUrl";
    m_roleNames[DescriptionRole] = "description";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Vimeo::instance()->groupsLoaded()) {
        Vimeo::instance()->getGroups();
    }

    this->connect(Vimeo::instance(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
    this->connect(Vimeo::instance(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
}

VimeoUserGroupListModel::~VimeoUserGroupListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> VimeoUserGroupListModel::roleNames() const {
    return m_roleNames;
}
#endif

void VimeoUserGroupListModel::onGroupAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void VimeoUserGroupListModel::onGroupRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int VimeoUserGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Vimeo::instance()->groups()->size();
}

QVariant VimeoUserGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->id();
    case TitleRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->title();
    case ArtistRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->artist();
    case DateRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->date();
    case VideoCountRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(Vimeo::instance()->groups()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->thumbnailUrl();
    case DescriptionRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant VimeoUserGroupListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<GroupItem> VimeoUserGroupListModel::get(int row) const {
    return QSharedPointer<GroupItem>(Vimeo::instance()->groups()->at(row));
}

#ifdef QML_USER_INTERFACE
GroupItem* VimeoUserGroupListModel::getFromQML(int row) const {
    return Vimeo::instance()->groups()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void VimeoUserGroupListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
