#include "homescreenmodel.h"

HomescreenModel::HomescreenModel(QObject *parent) :
    QAbstractListModel(parent)
{
    m_roleNames[NameRole] = "name";
    m_roleNames[IconSourceRole] = "iconSource";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif
    m_list.append(QPair<QString, QString>(tr("My Channel"), "images/mychannel.png"));
    m_list.append(QPair<QString, QString>(tr("Latest Videos"), "images/latest.png"));
    m_list.append(QPair<QString, QString>(tr("Categories"), "images/categories.png"));
    m_list.append(QPair<QString, QString>(tr("Social"), "images/social.png"));
    m_list.append(QPair<QString, QString>(tr("Search"), "images/search.png"));
    m_list.append(QPair<QString, QString>(tr("Queue"), "images/queue.png"));
    m_list.append(QPair<QString, QString>(tr("Transfers"), "images/transfers.png"));
    m_list.append(QPair<QString, QString>(tr("Archive"), "images/archive.png"));
    m_list.append(QPair<QString, QString>(tr("Accounts"), "images/accounts.png"));
#ifdef SAILFISH_OS
    m_list.append(QPair<QString, QString>(tr("Settings"), "images/settings.png"));
    m_list.append(QPair<QString, QString>(tr("About"), "images/about.png"));
#endif
}

HomescreenModel::~HomescreenModel() {}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> HomescreenModel::roleNames() const {
    return m_roleNames;
}
#endif

int HomescreenModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant HomescreenModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).first;
    case IconSourceRole:
        return m_list.at(index.row()).second;
    default:
        return QVariant();
    }
}

QVariant HomescreenModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}
