#ifndef YOUTUBERELATEDVIDEOSTAB_H
#define YOUTUBERELATEDVIDEOSTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class YouTubeVideoListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;
class QMenu;

class YouTubeRelatedVideosTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeRelatedVideosTab(QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showVideoInfo(QSharedPointer<VideoItem> video);

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void addVideosToFavourites();
    void addVideosToPlaylist();
    void addVideosToWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void addVideoToFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoToWatchLaterPlaylist();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    
private:
    QSharedPointer<VideoItem> m_video;
    YouTubeVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_addToFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_addToFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBERELATEDVIDEOSTAB_H
