#include "subtitlesselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>
#include <QDir>

SubtitlesSelector::SubtitlesSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new LanguageModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_model->removeRow(0);
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void SubtitlesSelector::setValue(const QString &value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toString() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

QString SubtitlesSelector::currentValue() {
    return m_model->value(m_selector->currentIndex()).toString();
}

void SubtitlesSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
