#include "screenorientationselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>

ScreenOrientationSelector::ScreenOrientationSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new ScreenOrientationModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void ScreenOrientationSelector::setValue(ScreenOrientation::Orientation value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<ScreenOrientation::Orientation>(m_model->value(i).toInt()) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

ScreenOrientation::Orientation ScreenOrientationSelector::currentValue() {
    return static_cast<ScreenOrientation::Orientation>(m_model->value(m_selector->currentIndex()).toInt());
}

void ScreenOrientationSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
