#ifndef DAILYMOTIONPLAYLISTVIDEOSWINDOW_H
#define DAILYMOTIONPLAYLISTVIDEOSWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"
#include "../base/videoitem.h"

class DailymotionVideoListModel;
class ListView;
class ThumbnailLabel;
class SeparatorLabel;
class QAction;
class QLabel;
class QScrollArea;
class QPushButton;
class QModelIndex;

class DailymotionPlaylistVideosWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionPlaylistVideosWindow(QSharedPointer<PlaylistItem> playlist, QWidget *parent);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void deleteVideosFromPlaylist();
    void addVideosToFavourites();
    void addVideosToPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromPlaylist();
    void addVideoToFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);
    void playPlaylist();
    void showUserChannel();
    void setThumbnails();
    void parseActivatedLink(const QString &link);

private:
    QSharedPointer<PlaylistItem> m_playlist;
    ListView *m_listView;
    DailymotionVideoListModel *m_model;
    QAction *m_deleteFromPlaylistAction;
    QAction *m_addToFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromPlaylistContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
};

#endif // DAILYMOTIONPLAYLISTVIDEOSWINDOW_H
