#include "vimeovideoinfowindow.h"
#include "vimeochannelwindow.h"
#include "vimeovideolistwindow.h"
#include "vimeovideodescriptiontab.h"
#include "vimeovideocommentstab.h"
#include "vimeorelatedvideostab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

VimeoVideoInfoWindow::VimeoVideoInfoWindow(QSharedPointer<VideoItem> video, QWidget *parent) :
    StackedWindow(parent),
    m_video(video),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_infoAction(new QAction(tr("Info"), this)),
    m_commentsAction(new QAction(tr("Comments"), this)),
    m_relatedAction(new QAction(tr("Related"), this)),
    m_tabWidget(new QStackedWidget(this)),
    m_infoTab(new VimeoVideoDescriptionTab(video, this)),
    m_commentsTab(0),
    m_relatedTab(0)
{
    this->setWindowTitle(tr("Video info"));
    this->setCentralWidget(m_tabWidget);

    m_infoAction->setCheckable(true);
    m_infoAction->setActionGroup(m_actionGroup);
    m_commentsAction->setCheckable(true);
    m_commentsAction->setActionGroup(m_actionGroup);
    m_relatedAction->setCheckable(true);
    m_relatedAction->setActionGroup(m_actionGroup);
    m_actionGroup->setExclusive(true);

    m_menu->addAction(m_infoAction);
    m_menu->addAction(m_commentsAction);
    m_menu->addAction(m_relatedAction);

    m_infoAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_infoTab);

    this->connect(m_infoAction, SIGNAL(triggered()), this, SLOT(showInfo()));
    this->connect(m_commentsAction, SIGNAL(triggered()), this, SLOT(showComments()));
    this->connect(m_relatedAction, SIGNAL(triggered()), this, SLOT(showRelatedVideos()));

    this->showInfo();
    this->onOrientationChanged();
}

void VimeoVideoInfoWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void VimeoVideoInfoWindow::showInfo() {
    m_tabWidget->setCurrentWidget(m_infoTab);
    this->setWindowTitle(tr("Info"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_infoTab->actions());
}

void VimeoVideoInfoWindow::showComments() {
    if (!m_commentsTab) {
        m_commentsTab = new VimeoVideoCommentsTab(m_video, this);
        m_tabWidget->addWidget(m_commentsTab);
    }

    m_tabWidget->setCurrentWidget(m_commentsTab);
    this->setWindowTitle(tr("Comments"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_commentsTab->actions());
}

void VimeoVideoInfoWindow::showRelatedVideos() {
    if (!m_relatedTab) {
        m_relatedTab = new VimeoRelatedVideosTab(m_video, this);
        m_tabWidget->addWidget(m_relatedTab);
    }

    m_tabWidget->setCurrentWidget(m_relatedTab);
    this->setWindowTitle(tr("Related videos"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_relatedTab->actions());
}
