#ifndef NETWORKPROXYTYPESELECTOR_H
#define NETWORKPROXYTYPESELECTOR_H

#include "../base/enums.h"
#include <QMaemo5ValueButton>

class NetworkProxyTypeModel;
class QMaemo5ListPickSelector;

class NetworkProxyTypeSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit NetworkProxyTypeSelector(const QString &text, QWidget *parent = 0);
    void setValue(NetworkProxyType::ProxyType value);
    NetworkProxyType::ProxyType currentValue();

private slots:
    void onSelected();

signals:
    void valueChanged(NetworkProxyType::ProxyType value);

private:
    NetworkProxyTypeModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // NETWORKPROXYTYPESELECTOR_H
