#include "languageselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>
#include <QDir>

LanguageSelector::LanguageSelector(const QString &text, bool hideUnavailable, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new LanguageModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    if (hideUnavailable) {
        this->hideUnavailableLanguages();
    }

    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void LanguageSelector::setValue(const QString &value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toString() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

QString LanguageSelector::currentValue() {
    return m_model->value(m_selector->currentIndex()).toString();
}

void LanguageSelector::onSelected() {
    emit valueChanged(this->currentValue());
}

void LanguageSelector::hideUnavailableLanguages() {
    QDir dir("/opt/cutetube/translations");
    QStringList availableLanguages = dir.entryList(QStringList("*.qm"), QDir::Files);
    QList<int> rowsToRemove;

    for (int i = 0; i < m_model->rowCount(); i++) {
        QString lang = m_model->value(i).toString();

        if (!availableLanguages.contains(QString("cutetube_%1.qm").arg(lang))) {
            rowsToRemove.prepend(i);
        }
        else {
            availableLanguages.removeOne(lang);
        }
    }

    while (!rowsToRemove.isEmpty()) {
        m_model->removeRows(rowsToRemove.takeFirst(), 1);
    }
}
