#ifndef GROUPITEM_H
#define GROUPITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QVariantMap>
#include <QDomElement>

class GroupItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               NOTIFY artistChanged)
    Q_PROPERTY(QString artistId
               READ artistId
               NOTIFY artistIdChanged)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               NOTIFY artistAvatarUrlChanged)
    Q_PROPERTY(QString description
               READ description
               NOTIFY descriptionChanged)
    Q_PROPERTY(QString date
               READ date
               NOTIFY dateChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               NOTIFY thumbnailUrlChanged)
    Q_PROPERTY(int videoCount
               READ videoCount
               NOTIFY videoCountChanged)
    Q_PROPERTY(bool member
               READ member
               WRITE setMember
               NOTIFY memberChanged)
    Q_PROPERTY(Services::VideoService service
               READ service
               NOTIFY serviceChanged)

public:
    explicit GroupItem(QObject *parent = 0);
    explicit GroupItem(GroupItem *group, QObject *parent = 0);
    ~GroupItem() {}
    Q_INVOKABLE void loadGroup(GroupItem *group);
    void loadDailymotionGroup(const QVariantMap &group, bool member = false);
    void loadVimeoGroup(const QDomElement &group);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; emit artistChanged(artist); }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; emit artistIdChanged(id); }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; emit artistAvatarUrlChanged(url); }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; emit dateChanged(date); }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; emit thumbnailUrlChanged(url); }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(count); }
    inline bool member() const { return m_member; }
    inline void setMember(bool member) { m_member = member; emit memberChanged(member); }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(GroupItem *other) { return other->id() == this->id(); }

public slots:
    void onMembershipChanged(const QString &groupId, bool member);

signals:
    void titleChanged(const QString &title);
    void artistChanged(const QString &artist);
    void artistIdChanged(const QString &id);
    void artistAvatarUrlChanged(const QUrl &url);
    void descriptionChanged(const QString &description);
    void dateChanged(const QString &date);
    void thumbnailUrlChanged(const QUrl &url);
    void videoCountChanged(int count);
    void memberChanged(bool member);
    void serviceChanged(Services::VideoService service);

private:
    QString m_id;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    QString m_date;
    QUrl m_thumbnailUrl;
    int m_videoCount;
    bool m_member;
    Services::VideoService m_service;
};

#endif // GROUPITEM_H
