# -*- coding: utf-8 -*-

"""
Module implementing the AboutWindow and its child windows.
"""
from __future__ import with_statement
from PyQt4.QtCore import *
from PyQt4.QtGui import QMainWindow, QTextEdit, QProgressBar
from Ui_aboutwindow import Ui_AboutWindow
from Ui_webviewwindow import Ui_WebViewWindow
from Ui_logwindow import Ui_LogWindow
from PyQt4.QtMaemo5 import QMaemo5InformationBox

class AboutWindow(QMainWindow, Ui_AboutWindow):
    """
    This window displays the manual and log, 
    along with other options.
    """
    def __init__(self, parent):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.show()
        
    @pyqtSignature("")
    def on_actionManual_triggered(self):
        """
        Raises the ManualWindow displaying the cuteTube manual.
        """
        manualWindow = WebViewWindow(self, "cuteTube Manual", "file:///opt/cutetube/manual.html")
        
    @pyqtSignature("")
    def on_actionLog_triggered(self):
        """
        Raises the LogWindow displaying the cuteTube log.
        """
        logWindow = LogWindow(self)
        
    @pyqtSignature("")
    def on_actionReportBug_triggered(self):
        """
        Raises the ReportBugWindow displaying the bugtracker web page.
        """
        reportBugWindow = WebViewWindow(self, "Report Bug", "https://garage.maemo.org/tracker/?group_id=1974")
        
    @pyqtSignature("")
    def on_actionDonate_triggered(self):
        """
        Raises the DonateWindow displaying the PayPal donate web page.
        """
        donateWindow = WebViewWindow(self, "Donate", "https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=cuteTube&currency_code=USD&bn=PP-DonationsBF:btn_donate_SM.gif:NonHosted")
        
class WebViewWindow(QMainWindow, Ui_WebViewWindow):
    """
    Displays the cuteTube manual.
    """
    def __init__(self, parent, title, webPage):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setWindowTitle(title)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.progressBar = QProgressBar(self)
        self.progressBar.setTextVisible(False)
        self.toolBar.addWidget(self.progressBar)
        self.connect(self.webView, SIGNAL("loadProgress(int)"), self.updateLoadProgress)
        self.connect(self.webView, SIGNAL("loadFinished(bool)"), self.loadFinished)
        self.loadWebPage(webPage)
        self.show()
        
    def updateLoadProgress(self, progress):
        """
        Sets the progress bar accordingly.
        """
        self.progressBar.setValue(progress)
        
    def loadFinished(self):
        """
        Hides the progress bar.
        """
        self.toolBar.setVisible(False)
        
    def loadWebPage(self, webPage):
        """
        Loads the appropriate web page into the QWebView.
        """
        self.webView.load(QUrl(webPage))
        
class LogWindow(QMainWindow, Ui_LogWindow):
    """
    Displays the cuteTube log.
    """
    def __init__(self, parent):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        log = self.getLog()
        self.textBrowser.setPlainText(log)
        self.show()
        
    def getLog(self):
        """
        Reads the log file.
        """
        with open("/home/user/.config/Stuart Howarth/cuteTube.log", "r") as file:
            log = file.read()
        file.close()
        return log
        
    @pyqtSignature("")
    def on_actionCopyLog_triggered(self):
        """
        Copies the log to the clipboard.
        """
        self.textBrowser.selectAll()
        self.textBrowser.copy()
        QMaemo5InformationBox.information(self, "Log copied to clipboard")
        
