# -*- coding: utf-8 -*-

"""
This module holds the application settings.
"""

from PyQt4.QtCore import QString, QStringList

class YouTubeAPISettings():
    """
    Provides the settings for access to the YouTube API.
    """
    userDict = {}
    defaultUser = ""
    raiseNoAccountFoundDialog = True

class VideoPlaybackSettings():
    """
    Provides the video playback settings.
    """
    playbackFormat = "18"
    formatList = ["17", "18"]
    
class VideoDownloadSettings():
    """
    Provides the video download settings.
    """
    downloadFolder = "/home/user/MyDocs/.videos"
    downloadFormat = "18"
    formatList = ["17", "18", "34", "35", "22"]
    defaultTaskStatus = "queued"
    
class SearchSettings():
    """
    Provides the settings for YouTube searches.
    """
    searchOrder = 0
    recentSearches = QStringList()
     
