#ifndef CURRENCY_H
#define CURRENCY_H

#include <QDialog>
#include <QSettings>
#include <QModelIndex>
#include <QInputDialog>
#include "edit.h"


namespace Ui {
    class Currency;
}

class Currency : public QDialog {
    Q_OBJECT
public:
    Currency(QWidget *parent = 0);
    ~Currency();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Currency *ui;
    QSettings mvSettings;
    QString mvCurrency1;
    QString mvCurrency2;
    bool mvAutoUpdate;
    Edit *editDialog;

    void displayRate();
    void updateList();

private slots:
    void on_checkBox_AutoUpdate_clicked(bool checked);
    void on_pushButton_Edit_clicked();
    void on_pushButton_Apply_clicked();
    void on_listWidget2_clicked(QModelIndex index);
    void on_listWidget1_clicked(QModelIndex index);
};

#endif // CURRENCY_H
